IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CPJ_Verificacion_Saldos_Clientes') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.[CPJ_Verificacion_Saldos_Clientes]
END
GO

CREATE PROCEDURE [dbo].[CPJ_Verificacion_Saldos_Clientes]  @pJsonRecibido VARCHAR(8000)	 

AS

DECLARE 	@pFecha_Desde		DATETIME,
			@pFecha_Hasta		DATETIME,
			@pAgrupaCli         TINYINT


SET @pFecha_Desde				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'Fecha_Desde')),GETDATE())
SET @pFecha_Hasta				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'Fecha_Hasta')),GETDATE())
SET @pAgrupaCli			     	= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'AgrupaCli')),0)

--VERSION: 10/02/2022

		select c.id_cliente,isnull(K.id_cliente_Ref,k.id_cliente) as Cliente_Ref,cast(sum(Isnull(t.Importe,0)*Isnull(c.Cotizacion,1)) as decimal(14,2)) as DEUDA
		Into #Verificacion
		from  clientes_ctacte t, Cbtes C, Clientes K 
		where c.id_trans = t.id_trans
		and c.id_cliente = K.id_cliente
		and t.Id_Estado_Cbte not in (0,3)
		and c.id_cliente >1
		group by  c.id_cliente,isnull(K.id_cliente_Ref,k.id_cliente)  

		ALTER TABLE #Verificacion ADD Rescta Decimal(14,2),Diferencia Decimal(14,2)

		UPDATE #Verificacion SET Rescta = 0, DIFERENCIA = 0
		Update #Verificacion SET Cliente_Ref = Id_Cliente where Cliente_Ref = 0
		

		select C.id_cliente,isnull(K.id_cliente_Ref,k.id_cliente) as cliente_Ref, sum(isnull(c.imp_total,0)*t.compromete_factura*Isnull(c.cotizacion,1))  as Rescta
		Into #Facturas
		from cbtes c, cbtes_tipos t, Clientes K 
		where c.id_tipo_cbte = t.Id_Tipo_Cbte
		and c.id_cliente = K.id_cliente
		and compromete_factura in (1,-1)
		and c.Id_Estado_Cbte not in (0,3)
		and c.id_cliente > 1
		and c.Id_Cond_Pago <> 1
		group by  c.id_cliente,isnull(K.id_cliente_Ref,k.id_cliente)  

		Update #Facturas SET Cliente_Ref = Id_Cliente where Cliente_Ref = 0


		select c.id_cliente,isnull(K.id_cliente_Ref,k.id_cliente) as Cliente_Ref,sum(Isnull(c.imp_total,0)*Isnull(c.cotizacion,1)) as recibos
		into #Recibos
		from cbtes c, cbtes_tipos t, Clientes K 
		where c.id_tipo_cbte = t.Id_Tipo_Cbte
		and c.id_cliente = K.id_cliente
		and compromete_recibos in (1,-1)
		and c.Id_Estado_Cbte not in (0,3)
		and c.id_cliente > 1
		group by  c.id_cliente,isnull(K.id_cliente_Ref,k.id_cliente)  

		Update #Recibos SET Cliente_Ref = Id_Cliente where Cliente_Ref = 0


		Update #Verificacion set Rescta = R.Rescta  from #Verificacion C, #Facturas R Where C.Id_Cliente = R.Id_Cliente And C.Cliente_Ref = R.Cliente_Ref

		Update #Verificacion set Rescta = C.Rescta - R.Recibos from #Verificacion C, #Recibos R Where C.Id_Cliente = R.Id_Cliente And C.Cliente_Ref = R.Cliente_Ref

		Update #Verificacion set Diferencia = Rescta - Deuda  

        IF @pAgrupaCli <> 1
		   BEGIN
			  SELECT v.id_cliente,c.razon_social,SUM(Rescta),SUM(Deuda),SUM(Diferencia) FROM #Verificacion V,Clientes C 
			  where c.id_cliente = V.Id_cliente  GROUP BY v.id_cliente,c.razon_social having SUM(Diferencia) <> 0 order by C.Razon_Social
		   END
		ELSE
		   BEGIN
			  SELECT v.Cliente_Ref,c.razon_social,SUM(Rescta),SUM(Deuda),SUM(Diferencia) FROM #Verificacion V,Clientes C 
			  where c.id_cliente = V.Cliente_Ref  GROUP BY v.Cliente_Ref,c.razon_social having SUM(Diferencia) <> 0 order by C.Razon_Social
		   END		  

		DROP TABLE #Verificacion
		DROP TABLE #Recibos
		DROP TABLE #Facturas


	--	CPJ_Verificacion_Saldos_Clientes '{}' 